package net.kldp.logviewer;

import net.kldp.logviewer.common.log.LogViews;
import net.kldp.logviewer.model.GetLogDBInfo;
import net.kldp.logviewer.model.LogViewerEntry;
import net.kldp.logviewer.model.LogViewerGroup;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * ű α ߰Ѵ.
 * 
 * @author hangum
 *
 */
public class AddLogAction extends Action implements ISelectionListener, IWorkbenchAction {

	private static final Logger logger = LogViews.getLogger(AddLogAction.class);
	
	private final IWorkbenchWindow window;
	public final static String ID = "net.kldp.logviewer.AddLog";
	private IStructuredSelection selection;
	String _groupNm = "";
	long _groupSeq = 0l;
	
	LogViewerEntry entry = new LogViewerEntry();
	
    public AddLogAction(IWorkbenchWindow window, String label) {    	
        super(label);
        
        this.window = window;
        // The id is used to refer to the action in a menu or toolbar
        setId(ICommandIds.CMD_OPEN_MESSAGE);
        // Associate the action with a pre-defined command, to allow key bindings.
        setActionDefinitionId(ICommandIds.CMD_OPEN_MESSAGE);
        setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(Application.PLUGIN_ID, IImageKeys.LOG_NEW));
        
        window.getSelectionService().addSelectionListener(this);
    }

    public void dispose() {
		window.getSelectionService().removeSelectionListener(this);
	}

	public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
		
		if (incoming instanceof IStructuredSelection) {
			selection = (IStructuredSelection) incoming;			
			
			// ׷ ý ű̴.
			if(selection.size() == 1 &&  selection.getFirstElement() instanceof LogViewerGroup) {
				LogViewerGroup group = (LogViewerGroup)selection.getFirstElement();
				_groupNm = group.getName();
				_groupSeq = group.getGroupSeq();
				
				setEnabled(true);
			} else {
				setEnabled(false);
			}
		
		} else {
			// Other selections, for example containing text or of other kinds.
			setEnabled(false);
		}
	}

	public void run() {
		entry = new LogViewerEntry();
		
		try {
			AddOrModifyLogView view = new AddOrModifyLogView(window.getShell(), _groupNm, entry);
			int code = view.open();
			
			if(code == Window.OK) {		
				LogViewerGroup group = (LogViewerGroup)selection.getFirstElement();
				entry = view.get_entry();
			
				GetLogDBInfo info = new GetLogDBInfo();			
				entry.setGroupSeq(group.getGroupSeq());
				entry.setSeq(info.getMaxEntry());
				
				info.saveLogViewerEntry(entry);
					
				// ű ׷ ߰Ѵ.
				group.addEntry(entry);
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
	}	
}